window.__bridge = (function() {
  var
  WebBridgeObjectProxyModeAuto    = 0,
  WebBridgeObjectProxyModeDirect  = 1,
  WebBridgeObjectProxyModeMapped  = 2,
  WebBridgeObjectProxyModeOrdered = 3,
  __token = null,
  __processing = false,
  __queue = [],
  __requests = {},
  __addBridge = function(interface, name, options) {
    var parent = __addNamespace(interface);
    var async = options.async;
    var mode = options.mode;
    parent[name] = function() {
      var parameters = null;
      var callbacks = null;
      var argumentCount = arguments.length;
      if (argumentCount) {
        parameters = [];
        var argument;
        var collection = parameters;
        for (var argumentIndex = 0; argumentIndex < argumentCount; ++argumentIndex) {
          argument = arguments[argumentIndex];
          if (!callbacks && ('function' == typeof argument)) {
            callbacks = [];
            collection = callbacks;
          }
          collection.push(argument);
        }
      }
      return __send(interface, name, async, mode, parameters, callbacks);
    };
  },
  __addFunction = function(interface, name, value) {
    __addNamespace(interface)[name] = eval('('+value+')');
  },
  __addNamespace = function(interface) {
    var parts = interface.split('.');
    var parent = window;
    var length = parts.length;
    for (var i = 0; i < length; ++i) {
      parent = parent[parts[i]] = parent[parts[i]] || {};
    }
    return parent;
  },
  __addVariable = function(interface, name, value) {
    __addNamespace(interface)[name] = value;
  },
  __generateToken = function() {
    return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(c) {
      var r = Math.random()*16|0;
      var v = c == 'x' ? r : (r&0x3|0x8);
      return v.toString(16);
    }).toUpperCase();
  },
  __send = function(interface, method, async, mode, parameters, callbacks) {
    var parameterCount = (parameters ? parameters.length : 0);
    if (WebBridgeObjectProxyModeAuto == mode) {
      if (1 == parameterCount) {
        if ('object' == typeof parameters[0]) {
          mode = WebBridgeObjectProxyModeMapped;
        } else {
          mode = WebBridgeObjectProxyModeDirect;
        }
      } else {
        mode = WebBridgeObjectProxyModeOrdered;
      }
    }
    switch (mode) {
      case WebBridgeObjectProxyModeDirect:
        parameters = (parameterCount ? parameters[0] : null);
        break;
      case WebBridgeObjectProxyModeMapped:
        parameters = (
        (parameterCount && ('object' == typeof parameters[0])) ?
        parameters[0] :
        null);
        break;
    }
    var callbackCount = (callbacks ? callbacks.length : 0);
    if (callbackCount) {
      var callbackArray = callbacks;
      callbacks = {};
      if (2 < callbackCount) {
        callbacks.callback = callbackArray[2];
      }
      if (1 < callbackCount) {
        callbacks.failureCallback = callbackArray[1];
      }
      callbacks.successCallback = callbackArray[0];
    }
    var data = {
      async:async,
      interface:interface,
      method:method,
      parameters:parameters,
      fireAndForget:(async && (0 == callbackCount))
    };
    var url = 'http://'+(location.host||'localhost')+'/__bridge__/'+__token+'/'+__generateToken();
    if (async) {
      data.token = __generateToken();
      __requests[data.token] = {
        callbacks:callbacks,
        data:data
      };
      __queue.push(data.token);
      if (!__processing) {
        var xhr = new XMLHttpRequest();
        xhr.open("GET",
                 url,
                 true);
        try{
          xhr.send();
        }catch(e){}
      }
      return data.token;
    } else {
      var xhr = new XMLHttpRequest();
      xhr.open("GET",
               url+'/'+JSON.stringify(data),
               false);
      try{
        xhr.send();
      }catch(e){}
      var value = xhr.responseText;
      return (value && value.length && (' ' != value) ? eval('('+value+')') : null);
    }
  },
  Bridge = function() {};
  Bridge.prototype = {
    addInterface:function(interface, variables, bridges, functions) {
      if (variables) {
        for (var key in variables) {
          __addVariable(interface, key, variables[key]);
        }
      }
      if (bridges) {
        for (var key in bridges) {
          __addBridge(interface, key, bridges[key]);
        }
      }
      if (functions) {
        for (var key in functions) {
          __addFunction(interface, key, functions[key]);
        }
      }
    },
    configure:function(token) {
      __token = token;
    },
    getNextRequest:function() {
      var token = __queue.splice(0, 1);
      var data = __requests[token];
      if (data && data.data && data.data.fireAndForget) {
        delete __requests[token];
      }
      return (data && data.data ? JSON.stringify(data.data) : null);
    },
    receive:function(token, value, error) {
      var data = __requests[token];
      if (data) {
        delete __requests[token];
        var callbacks = data.callbacks;
        if (callbacks) {
          var response = {
            value:value,
            error:error,
            interface:data.data.interface,
            method:data.data.method,
            parameters:data.data.parameters
          }
          if (error) {
            if (callbacks.failureCallback) {
              callbacks.failureCallback(response);
            }
          } else {
            if (callbacks.successCallback) {
              callbacks.successCallback(response);
            }
          }
          if (callbacks.callback) {
            callbacks.callback(response);
          }
        }
      }
    },
    removeInterface:function(interface, keys) {
      var parts = interface.split('.');
      var proxy = window;
      var length = parts.length;
      for (var i = 0; i < length; ++i) {
        proxy = proxy[parts[i]];
      }
      if (proxy) {
        length = keys.length;
        for (var i = 0; i < length; ++i) {
          delete proxy[keys[i]];
        }
      }
    },
    updateProcessing:function(processing) {
      __processing = processing;
    }
  };
  return new Bridge();
})();
